#include <iostream>
#include <vector>

using namespace std;

bool can_overtake(double time, const vector<int>& positions, const vector<int>& speeds, int K) {
    int overtakes = 0;
    int N = positions.size();

    for (int i = 0; i < N; ++i) {
        for (int j = i + 1; j < N; ++j) {
            if (positions[i] + time * speeds[i] < positions[j] + time * speeds[j]) {
                overtakes++;
            }
        }
    }

    return overtakes >= K;
}

double find_overtaking_time(int N, int K, const vector<int>& positions, const vector<int>& speeds) {
    double low = 0;
    double high = 1e18;

    while (high - low > 1e-9) {
        double mid = (low + high) / 2;
        if (can_overtake(mid, positions, speeds, K)) {
            high = mid;
        } else {
            low = mid;
        }
    }

    return low;
}

int main() {
    int N, K;
    cin >> N >> K;

    vector<int> positions(N);
    vector<int> speeds(N);

    for (int i = 0; i < N; ++i) {
        cin >> positions[i] >> speeds[i];
    }

    double result = find_overtaking_time(N, K, positions, speeds);
    cout << fixed << result << endl;

    return 0;
}